<?php
/**
* Plugin Name: Meterbeheer Energy Data Hub
* Plugin URI: https://localhost
* Description: The Meterbeheer Wordpress plugin lets websites show the data from a Meterbeheer datafeed on a Wordpress website.
* Version: 1.0
* Author: Rahul
* Author URI: https://localhost
**/

function meterbeheer_energydatahub_enqueued_assets() {
  wp_enqueue_script('meterbeheer-js-file', plugin_dir_url(__FILE__) . '/js/meterbeheer-energydatahub.js', '', time());
  wp_localize_script( 'meterbeheer-js-file', 'meterbeheer_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
  wp_enqueue_style('meterbeheer-css-file', plugin_dir_url(__FILE__) . '/css/meterbeheer-energydatahub.css', '', time());
  wp_enqueue_style('meterbeheer-css-googleapis', '//fonts.googleapis.com');
  wp_enqueue_style('meterbeheer-css-gstatic', '//fonts.gstatic.com'); 
  wp_enqueue_style('meterbeheer-css-googleapis-family', '//fonts.googleapis.com/css2?family=Arimo:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&family=Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&family=Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Noto+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Nunito:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Open+Sans+Condensed:ital,wght@0,300;0,700;1,300&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Oswald:wght@200;300;400;500;600;700&family=PT+Sans+Narrow:wght@400;700&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=PT+Serif:ital,wght@0,400;0,700;1,400;1,700&family=Playfair+Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto+Condensed:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700&family=Roboto+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&family=Roboto+Slab:wght@100;200;300;400;500;600;700;800;900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Slabo+27px&family=Source+Sans+Pro:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700;1,900&family=Titillium+Web:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700&family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&display=swap'); 
}
add_action('wp_enqueue_scripts', 'meterbeheer_energydatahub_enqueued_assets');

add_shortcode( 'meterbeheer-energydatahub', 'meterbeheer_energydatahub_callback' );
function meterbeheer_energydatahub_callback($params = array()){

  extract(shortcode_atts(array(
    'feedurl' => 'https://hub.meterbeheer.nl/feed/70fbe0de-7140-49d1-9c30-b5081dc3f023/10180.json',
    'title1' => 'Title 1',
    'title2' => 'Title 2',
    'unit' => 'Unit',
    'poweredby' => 'Powered By',
    'realtime' => 'no'
  ), $params));


  $url = $feedurl;

  $url = str_replace( 'http://', 'https://', $url );


  $curl = curl_init($url);
  curl_setopt($curl, CURLOPT_URL, $url);
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

  $headers = array(
     "Accept: application/json",
  );
  curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
  //for debug only!
  curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

  $resp = curl_exec($curl);
  curl_close($curl);

  $jsonDecode = json_decode($resp, true);
  //echo "<pre>";
  //print_r($jsonDecode);

  $meteringData = $jsonDecode['metering_data'] ;

  if($realtime == "yes"){

    $finalReading = '';

    foreach ($meteringData as $data) {
      //echo $data['value'];
      $finalReading = ($finalReading+$data['value']) ;
      $fromDate = date_create($data['from']);
      //$fromDateConverted = date_format($fromDate, 'F jS Y');
      $fromDateConverted = date_format($fromDate, 'F jS Y');
      $timestamp = strtotime($fromDateConverted);
      setlocale(LC_TIME, 'nl_NL');
      $fromDateConverted = strftime('%d %B %Y', $timestamp);
      $fromTimeConverted = date_format($fromDate, 'h:i');
    }

    $output = '<div class="meterbeheer-energydatahub-container">';

    $output .= '<div class="meterbeheer-card"><div class="meterbeheer-container"><h2>'.$title1.'</h2><h4>'.$title2.'</h4><div class="data-units"><span class="data">'.number_format($finalReading, 2, ',', '.').'</span><span class="unit">'.$unit.'</span></div><div class="date-periode"><span class="date">'.$fromDateConverted.'</span><span class="periode"> - '.$fromTimeConverted.'</span></div><div class="powered-by"><span class="powered-by-text">'.$poweredby.'</span><span class="powered-by-logo"><a href="https://www.meterbeheer.nl/" target="_blank"><img src="'.plugin_dir_url(__FILE__) . 'img/meterbeheer-logo.jpg"></a></span></div></div></div>';
    $output .= '</div>';

  }else{

    $finalReading = '';


    foreach ($meteringData as $data) {
      //echo $data['value'];
      $finalReading = ($finalReading+$data['value']) ;
      $fromDate = date_create($data['from']);
      //$fromDateConverted = date_format($fromDate, 'F jS Y');  
      $fromDateConverted = date_format($fromDate, 'F jS Y');
      $timestamp = strtotime($fromDateConverted);
      setlocale(LC_TIME, 'nl_NL');
      $fromDateConverted = strftime('%d %B %Y', $timestamp);
    }

    /* $timestamp = strtotime($fromDateConverted);
    setlocale(LC_ALL, 'nl_NL');
    echo strftime('%B %d, %Y', $timestamp); */

    $output = '<div class="meterbeheer-energydatahub-container">';

    $output .= '<div class="meterbeheer-card"><div class="meterbeheer-container"><h2>'.$title1.'</h2><h4>'.$title2.'</h4><div class="data-units"><span class="data">'.number_format($finalReading, 2, ',', '.').'</span><span class="unit">'.$unit.'</span></div><div class="date-periode"><span class="date">'.$fromDateConverted.'</span></div><div class="powered-by"><span class="powered-by-text">'.$poweredby.'</span><span class="powered-by-logo"><a href="https://www.meterbeheer.nl/" target="_blank"><img src="'.plugin_dir_url(__FILE__) . 'img/meterbeheer-logo.jpg"></a></span></div></div></div>';
    $output .= '</div>';

  }

  $options = get_option( 'meterbeheer_settings' );
  $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");

  $meterbeheer_container_bg_colour = trim($options["meterbeheer_container_bg_colour"]) ;

  $meterbeheer_text_1_colour = trim($options["meterbeheer_text_1_colour"]) ;
  $meterbeheer_text_1_size = trim($options["meterbeheer_text_1_size"]) ;
  $meterbeheer_select_title1_family = trim($options["meterbeheer_select_title1_family"]) ;

  $meterbeheer_text_2_colour = trim($options["meterbeheer_text_2_colour"]) ;
  $meterbeheer_text_2_size = trim($options["meterbeheer_text_2_size"]) ;
  $meterbeheer_select_title2_family = trim($options["meterbeheer_select_title2_family"]) ;

  $meterbeheer_data_field_colour = trim($options["meterbeheer_data_field_colour"]) ;
  $meterbeheer_data_field_size = trim($options["meterbeheer_data_field_size"]) ;
  $meterbeheer_select_data_family = trim($options["meterbeheer_select_data_family"]) ;

  $meterbeheer_units_colour = trim($options["meterbeheer_units_colour"]) ;
  $meterbeheer_units_size = trim($options["meterbeheer_units_size"]) ;
  $meterbeheer_select_units_family = trim($options["meterbeheer_select_units_family"]) ;

  $meterbeheer_date_colour = trim($options["meterbeheer_date_colour"]) ;
  $meterbeheer_date_size = trim($options["meterbeheer_date_size"]) ;
  $meterbeheer_select_date_family = trim($options["meterbeheer_select_date_family"]) ;

  $meterbeheer_time_colour = trim($options["meterbeheer_time_colour"]) ;
  $meterbeheer_time_size = trim($options["meterbeheer_time_size"]) ;
  $meterbeheer_select_time_family = trim($options["meterbeheer_select_time_family"]) ;

  $meterbeheer_poweredby_colour = trim($options["meterbeheer_poweredby_colour"]) ;
  $meterbeheer_poweredby_size = trim($options["meterbeheer_poweredby_size"]) ;
  $meterbeheer_select_poweredby_family = trim($options["meterbeheer_select_poweredby_family"]) ;
  
  $output .= '<style>.meterbeheer-card{background-color:'.$meterbeheer_container_bg_colour.';} .meterbeheer-container h2{font-size:'.$meterbeheer_text_1_size.';color:'.$meterbeheer_text_1_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_title1_family].';} .meterbeheer-container h4{font-size:'.$meterbeheer_text_2_size.';color:'.$meterbeheer_text_2_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_title2_family].';} .data-units span.data{font-size:'.$meterbeheer_data_field_size.';color:'.$meterbeheer_data_field_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_data_family].';} .data-units span.unit{font-size:'.$meterbeheer_units_size.';color:'.$meterbeheer_units_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_units_family].';} .date-periode span.date{font-size:'.$meterbeheer_date_size.';color:'.$meterbeheer_date_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_date_family].';} .date-periode .periode{font-size:'.$meterbeheer_time_size.';color:'.$meterbeheer_time_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_time_family].';} span.powered-by-text{font-size:'.$meterbeheer_poweredby_size.';color:'.$meterbeheer_poweredby_colour.';font-family:'.$fontFamilyArray[$meterbeheer_select_poweredby_family].';}</style>';

  return $output;
}

function add_meterbeheer_plugin_menu() {
    add_submenu_page('options-general.php', 'Meterbeheer Plugin Settings', 'Meterbeheer Plugin Settings', 'manage_options', 'meterbeheer-plugin', 'meterbeheer_plugin_function');
}
add_action('admin_menu', 'add_meterbeheer_plugin_menu');

function meterbeheer_settings_init() {

    register_setting( 'meterbeheer-setting', 'meterbeheer_settings' );

    add_settings_section('meterbeheer-plugin-section', __( 'Meterbeheer Plugin', 'meterbeheer-plugin' ), 'meterbeheer_settings_section_callback', 'meterbeheer-setting' );

    add_settings_field( 'meterbeheer_container_bg_colour', __( 'Container BG colour (e.g. : #fff or white):', 'meterbeheer-plugin' ), 'meterbeheer_container_bg_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_text_1_colour', __( 'Title text 1 font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_text_1_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_text_1_size', __( 'Title text 1 font size (e.g. : 20px):', 'meterbeheer-plugin' ), 'meterbeheer_text_1_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_text_2_colour', __( 'Title text 2 font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_text_2_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_text_2_size', __( 'Title text 2 font size (e.g. : 12px):', 'meterbeheer-plugin' ), 'meterbeheer_text_2_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_data_field_colour', __( 'Data Field font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_data_field_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_data_field_size', __( 'Data Field font size (e.g. : 38px):', 'meterbeheer-plugin' ), 'meterbeheer_data_field_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_units_colour', __( 'Units font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_units_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_units_size', __( 'Units font size (e.g. : 38px):', 'meterbeheer-plugin' ), 'meterbeheer_units_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_date_colour', __( 'Date font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_date_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_date_size', __( 'Date font size (e.g. : 16px):', 'meterbeheer-plugin' ), 'meterbeheer_date_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_time_colour', __( 'Time font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_time_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_time_size', __( 'Time font size (e.g. : 16px):', 'meterbeheer-plugin' ), 'meterbeheer_time_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_poweredby_colour', __( 'Powered By font colour (e.g. : #000 or black):', 'meterbeheer-plugin' ), 'meterbeheer_poweredby_colour', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_poweredby_size', __( 'Powered By font size (e.g. : 15px):', 'meterbeheer-plugin' ), 'meterbeheer_poweredby_size', 'meterbeheer-setting', 'meterbeheer-plugin-section' );

    add_settings_field( 'meterbeheer_select_title1_family', __( 'Title 1 Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_title1_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_select_title2_family', __( 'Title 2 Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_title2_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_select_data_family', __( 'Data Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_data_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_select_units_family', __( 'Units Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_units_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_select_date_family', __( 'Date Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_date_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_select_time_family', __( 'Time Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_time_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
    add_settings_field( 'meterbeheer_select_poweredby_family', __( 'Powered By Font Family:', 'meterbeheer-plugin' ), 'meterbeheer_select_poweredby_family', 'meterbeheer-setting', 'meterbeheer-plugin-section' );
}
add_action( 'admin_init', 'meterbeheer_settings_init' );

function meterbeheer_settings_section_callback(  ) {
    echo __( 'This is the setting page for meterbeheer plugin', 'meterbeheer-plugin' );
}

function meterbeheer_container_bg_colour(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_container_bg_colour = trim($options["meterbeheer_container_bg_colour"]);
    if($meterbeheer_container_bg_colour == ""){
      $meterbeheer_container_bg_colour = "white" ;
    }

    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_container_bg_colour]' value='<?php echo $meterbeheer_container_bg_colour; ?>'> <?php
}

function meterbeheer_text_1_colour(){
    $options = get_option( 'meterbeheer_settings' );
    $meterbeheer_text_1_colour = trim($options["meterbeheer_text_1_colour"]);
    if($meterbeheer_text_1_colour == ""){
      $meterbeheer_text_1_colour = "black" ;
    }

    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_text_1_colour]' value='<?php echo $meterbeheer_text_1_colour; ?>'> <?php
}

function meterbeheer_text_1_size(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_text_1_size = trim($options["meterbeheer_text_1_size"]);
    if($meterbeheer_text_1_size == ""){
      $meterbeheer_text_1_size = "20px" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_text_1_size]' value=' <?php echo $meterbeheer_text_1_size; ?>'> <?php
}

function meterbeheer_text_2_colour(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_text_2_colour = trim($options["meterbeheer_text_2_colour"]);
    if($meterbeheer_text_2_colour == ""){
      $meterbeheer_text_2_colour = "black" ;
    }

    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_text_2_colour]' value='<?php echo $meterbeheer_text_2_colour; ?>'> <?php
}

function meterbeheer_text_2_size(){
    $options = get_option( 'meterbeheer_settings' ); 

    $meterbeheer_text_2_size = trim($options["meterbeheer_text_2_size"]);
    if($meterbeheer_text_2_size == ""){
      $meterbeheer_text_2_size = "12px" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_text_2_size]' value=' <?php echo $meterbeheer_text_2_size; ?>'> <?php
}

function meterbeheer_data_field_colour(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_data_field_colour = trim($options["meterbeheer_data_field_colour"]);
    if($meterbeheer_data_field_colour == ""){
      $meterbeheer_data_field_colour = "black" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_data_field_colour]' value='<?php echo $meterbeheer_data_field_colour; ?>'> <?php
}

function meterbeheer_data_field_size(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_data_field_size = trim($options["meterbeheer_data_field_size"]);
    if($meterbeheer_data_field_size == ""){
      $meterbeheer_data_field_size = "18px" ;
    }

    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_data_field_size]' value=' <?php echo $meterbeheer_data_field_size; ?>'> <?php
}

function meterbeheer_units_colour(){
    $options = get_option( 'meterbeheer_settings' ); 

    $meterbeheer_units_colour = trim($options["meterbeheer_units_colour"]);
    if($meterbeheer_units_colour == ""){
      $meterbeheer_units_colour = "black" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_units_colour]' value='<?php echo $meterbeheer_units_colour; ?>'> <?php
}

function meterbeheer_units_size(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_units_size = trim($options["meterbeheer_units_size"]);
    if($meterbeheer_units_size == ""){
      $meterbeheer_units_size = "18px" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_units_size]' value=' <?php echo $meterbeheer_units_size; ?>'> <?php
}
function meterbeheer_date_colour(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_date_colour = trim($options["meterbeheer_date_colour"]);
    if($meterbeheer_date_colour == ""){
      $meterbeheer_date_colour = "black" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_date_colour]' value='<?php echo $meterbeheer_date_colour; ?>'> <?php
}
function meterbeheer_date_size(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_date_size = trim($options["meterbeheer_date_size"]);
    if($meterbeheer_date_size == ""){
      $meterbeheer_date_size = "16px" ;
    }

    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_date_size]' value=' <?php echo $meterbeheer_date_size; ?>'> <?php
}
function meterbeheer_time_colour(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_time_colour = trim($options["meterbeheer_time_colour"]);
    if($meterbeheer_time_colour == ""){
      $meterbeheer_time_colour = "black" ;
    }

    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_time_colour]' value='<?php echo $meterbeheer_time_colour; ?>'> <?php
}
function meterbeheer_time_size(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_time_size = trim($options["meterbeheer_time_size"]);
    if($meterbeheer_time_size == ""){
      $meterbeheer_time_size = "16px" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_time_size]' value=' <?php echo $meterbeheer_time_size; ?>'> <?php
}
function meterbeheer_poweredby_colour(){
    $options = get_option( 'meterbeheer_settings' ); 

    $meterbeheer_poweredby_colour = trim($options["meterbeheer_poweredby_colour"]);
    if($meterbeheer_poweredby_colour == ""){
      $meterbeheer_poweredby_colour = "black" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_poweredby_colour]' value='<?php echo $meterbeheer_poweredby_colour; ?>'> <?php
}
function meterbeheer_poweredby_size(){
    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_poweredby_size = trim($options["meterbeheer_poweredby_size"]);
    if($meterbeheer_poweredby_size == ""){
      $meterbeheer_poweredby_size = "15px" ;
    }
    ?>

    <input type='text' name='meterbeheer_settings[meterbeheer_poweredby_size]' value=' <?php echo $meterbeheer_poweredby_size; ?>'> <?php
}

function meterbeheer_select_title1_family(){

    $options = get_option( 'meterbeheer_settings' );
    $meterbeheer_select_title1_family = trim($options["meterbeheer_select_title1_family"]);
    if($meterbeheer_select_title1_family == ""){
      $meterbeheer_select_title1_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_title1_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_title1_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_select_title2_family(){

    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_select_title2_family = trim($options["meterbeheer_select_title2_family"]);
    if($meterbeheer_select_title2_family == ""){
      $meterbeheer_select_title2_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_title2_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_title2_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_select_data_family(){

    $options = get_option( 'meterbeheer_settings' );
    $meterbeheer_select_data_family = trim($options["meterbeheer_select_data_family"]);
    if($meterbeheer_select_data_family == ""){
      $meterbeheer_select_data_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_data_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_data_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_select_units_family(){

    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_select_units_family = trim($options["meterbeheer_select_units_family"]);
    if($meterbeheer_select_units_family == ""){
      $meterbeheer_select_units_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_units_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_units_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_select_date_family(){

    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_select_date_family = trim($options["meterbeheer_select_date_family"]);
    if($meterbeheer_select_date_family == ""){
      $meterbeheer_select_date_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_date_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_date_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_select_time_family(){

    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_select_time_family = trim($options["meterbeheer_select_time_family"]);
    if($meterbeheer_select_time_family == ""){
      $meterbeheer_select_time_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_time_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_time_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_select_poweredby_family(){

    $options = get_option( 'meterbeheer_settings' ); 
    $meterbeheer_select_poweredby_family = trim($options["meterbeheer_select_poweredby_family"]);
    if($meterbeheer_select_poweredby_family == ""){
      $meterbeheer_select_poweredby_family = "5" ;
    }
    $fontFamilyArray = array("1"=>"'Arimo', sans-serif", "2"=>"'Lato', sans-serif", "3"=>"'Lora', serif","4"=>"'Merriweather', serif", "5"=>"'Montserrat', sans-serif", "6"=>"'Noto Sans', sans-serif","7"=>"'Nunito', sans-serif", "8"=>"'Open Sans', sans-serif", "9"=>"'Open Sans Condensed', sans-serif","10"=>"'Oswald', sans-serif", "11"=>"'Playfair Display', serif", "12"=>"'Poppins', sans-serif","13"=>"'PT Sans', sans-serif", "14"=>"'PT Sans Narrow', sans-serif", "15"=>"'PT Serif', serif","16"=>"'Raleway', sans-serif", "17"=>"'Roboto', sans-serif", "18"=>"'Roboto Condensed', sans-serif","19"=>"'Roboto Mono', monospace", "20"=>"'Roboto Slab', serif", "21"=>"'Slabo 27px', serif", "22"=>"'Source Sans Pro', sans-serif", "23"=>"'Titillium Web', sans-serif", "24"=>"'Ubuntu', sans-serif");
    ?>
    <select name="meterbeheer_settings[meterbeheer_select_poweredby_family]">
      <option value="">Select Font Family</option>
      <?php
        foreach ($fontFamilyArray as $key => $value) {
          echo '<option value="'.$key.'" '. selected($meterbeheer_select_poweredby_family, $key) .'>'.$value.'</option>';
       } 
      ?> 
    </select>
    
<?php
}

function meterbeheer_plugin_function(){ ?>

    <form action='options.php' method='post'> <?php
        settings_fields( 'meterbeheer-setting' );
        do_settings_sections( 'meterbeheer-setting' );
        submit_button(); ?>
    </form> <?php
}